package testes;

import junit.framework.Assert;
import baseClass.*;
import org.junit.Test;

/**
 * @author jonhnanthan
 *
 */
public class ArquivoTest {

	@Test
	public void testLerArquivo() {
		Arquivo arq;
		try {
			arq = new Arquivo();
			arq.lerArquivo(null);
		} catch (Exception e) {
			Assert.assertEquals("Mensagem errada", "Arquivo nao encontrado!", e.getMessage());
		}
		
		try {
			arq = new Arquivo();
			arq.lerArquivo("");
		} catch (Exception e) {
			Assert.assertEquals("Mensagem errada", "Arquivo nao encontrado!", e.getMessage());
		}
		
		try {
			arq = new Arquivo();
			arq.lerArquivo("Estabelecimentos-v2.data");
		} catch (Exception e) {
			// O arquivo deve ser lido e nao ha nenhum retorno, pois o arquivo esta na pasta do projeto.
		}

		try {
			arq = new Arquivo();
			arq.lerArquivo("Opinioes-v2.data");
		} catch (Exception e) {
			// O arquivo deve ser lido e nao ha nenhum retorno, pois o arquivo esta na pasta do projeto.
		}

	}

	@Test
	public void testGetLinhasDoArquivoLido() {
		Arquivo arq = null;

		try {
			arq = new Arquivo();
			arq.lerArquivo(null);
		} catch (Exception e) {
			Assert.assertEquals("Mensagem errada", "Arquivo nao encontrado!", e.getMessage());
			Assert.assertEquals("Array de linhas nao esta vazio", 0, arq.getLinhasDoArquivoLido().size());
		}

		try {
			arq = new Arquivo();
			arq.lerArquivo("");
		} catch (Exception e) {
			Assert.assertEquals("Mensagem errada", "Arquivo nao encontrado!", e.getMessage());
			Assert.assertEquals("Array de linhas nao esta vazio", 0, arq.getLinhasDoArquivoLido().size());
		}

		try {
			arq = new Arquivo();
			arq.lerArquivo("Estabelecimentos-v2.data");
			Assert.assertEquals("Array de linhas nao esta preenchido", 40, arq.getLinhasDoArquivoLido().size());
		} catch (Exception e) {
			// como o arquivo foi lido, nunca entrara no cath
		}

		try {
			arq = new Arquivo();
			arq.lerArquivo("Opinioes-v2.data");
			Assert.assertEquals("Array de linhas nao esta preenchido", 167, arq.getLinhasDoArquivoLido().size());
		} catch (Exception e) {
			// como o arquivo foi lido, nunca entrara no cath
		}

	}

	@Test
	public void testEscreverEmArquivo() {
		Arquivo arq = null;
		
		try {
			arq = new Arquivo();
			arq.escreverEmArquivo("teste de escrita", "/home/TestaEscrita.txt");
		} catch (Exception e) {
			Assert.assertEquals("Mesagem errada", "Erro ao abrir o arquivo para escrita!", e.getMessage());
		}
		
		try {
			arq = new Arquivo();
			arq.escreverEmArquivo("teste de escrita", "TestaEscrita.txt");
			arq.lerArquivo("TestaEscrita.txt");
			Assert.assertEquals("Arquivo nao foi lido", 2, arq.getLinhasDoArquivoLido().size());
		} catch (Exception e) {
			//O arquivo nao existe, porem eh criado um novo porque a forma de escrita esta em modo de append.
			//Note que apos a primeira execucao o arquivo ja existe e ja possui linhas escritas, entao o valor
			//corresponde de linhas indicadas no assert acima sera diferente
		}

		try {
			arq = new Arquivo();
			arq.escreverEmArquivo("", "TestaEscrita.txt");
		} catch (Exception e) {
			Assert.assertEquals("Mesagem errada", "Eh vetado a escrita de linha vazia ou nula!", e.getMessage());
		}

		try {
			arq = new Arquivo();
			arq.escreverEmArquivo(null, "TestaEscrita.txt");
		} catch (Exception e) {
			Assert.assertEquals("Mesagem errada", "Eh vetado a escrita de linha vazia ou nula!", e.getMessage());
		}

	}

	@Test
	public void testTestaPadraoArquivoDeEstabelecimentos() {
		Arquivo arq = null;
		
		try {
			arq = new Arquivo();
			Assert.assertEquals("Erro no padrao do arquivo", 1, arq.testaPadraoArquivoDeEstabelecimentos("Estabelecimentos-v2.data"));
			Assert.assertEquals("Erro no padrao do arquivo", 0, arq.testaPadraoArquivoDeEstabelecimentos("Opinioes-v2.data"));
		} catch (Exception e) {
			// as excessoes a serem lancadas por este teste sao as mesmas de leitura de arquivo,
			// ja testadas acima
		}
	}

	@Test
	public void testTestaPadraoArquivoDeOpinioes() {
		Arquivo arq = null;
		
		try {
			arq = new Arquivo();
			Assert.assertEquals("Erro no padrao do arquivo", 1, arq.testaPadraoArquivoDeOpinioes("Opinioes-v2.data"));
			Assert.assertEquals("Erro no padrao do arquivo", 0, arq.testaPadraoArquivoDeOpinioes("Estabelecimentos-v2.data"));
		} catch (Exception e) {
			// as excessoes a serem lancadas por este teste sao as mesmas de leitura de arquivo,
			// ja testadas acima
		}
	}
}
